global root "C:\Users\Ian\Dropbox (MIT)\CE EIP code\CE EIP I"

import excel "$root\Labor Data Request.xlsx", sheet("EIP1 Dashboard") cellrange(A2:I77) firstrow clear
tempfile eip1
save `eip1'

import excel "$root\Labor Data Request.xlsx", sheet("EIP2 Dashboard") cellrange(A3:I6) firstrow clear
tempfile eip2
save `eip2'

import excel "$root\Labor Data Request.xlsx", sheet("EIP3 Dashboard") cellrange(A3:I83) firstrow clear
append using `eip1', force
append using `eip2', force

gen month = mofd(PaymentDate)
format month %tm
gcollapse (sum) TotalDollarAmount, by(month)
rename TotalDollarAmount EIP
replace EIP = EIP/1e9
tempfile EIP
save `EIP'

import fred PSAVERT MTSDS133FMS DSPI, daterange(2019-01-01 2022-07-29) aggregate(monthly,avg) clear
gen month = mofd(daten)
format month %tm
merge 1:1 month using `EIP', keep(mas mat) nogen
replace EIP = 0 if mi(EIP)
replace DSPI = DSPI/12
gen EIP2DSPI = EIP/DSPI*100
rename MTSDS133FMS deficit
replace deficit = deficit/1000
gen deficit2DSPI = deficit/DSPI*100

export delimited "$root/eip_dispinc.csv", replace 

# delimit ;
graph twoway (line PSAVERT EIP2DSPI month,
	lc(black dkgreen) lp(solid longdash))
	(line deficit2DSPI month, 
	lc(dkorange) lp(dash_dot) yaxis(2)),
	legend(order(1 "Personal saving rate (%) (left axis)" 
				 2 "EIP disbursement as a share of disposable income (%) (left axis)"
				 3 "Federal surplus as a share of disposable income (%) (right axis)") 
		   rows(3))
	xtitle("") ytitle("") ytitle("", axis(2));
# delimit cr




/* Figure on counterfactual PCE */
global EIP1_cont = 0.234
global EIP1_long = 0.217
global EIP2_cont = 0.247
global EIP2_long = 0.354
global EIP3_cont = 0.016
global EIP3_long = -0.134

global EIP1_cont_nd = 0.102
global EIP1_long_nd = 0.022
global EIP2_cont_nd = 0.083
global EIP2_long_nd = 0.070
global EIP3_cont_nd = 0.009
global EIP3_long_nd = -0.04


import excel "$root\Labor Data Request.xlsx", sheet("EIP1 Dashboard") cellrange(A2:I77) firstrow clear
keep PaymentDate TotalDollarAmount
rename TotalDollarAmount EIP1
tempfile eip1
save `eip1'

import excel "$root\Labor Data Request.xlsx", sheet("EIP2 Dashboard") cellrange(A3:I6) firstrow clear
keep PaymentDate TotalDollarAmount
rename TotalDollarAmount EIP2
tempfile eip2
save `eip2'

import excel "$root\Labor Data Request.xlsx", sheet("EIP3 Dashboard") cellrange(A3:I83) firstrow clear
keep PaymentDate TotalDollarAmount
rename TotalDollarAmount EIP3
append using `eip1', force
append using `eip2', force
gen month = mofd(PaymentDate)
format month %tm
gcollapse (sum) EIP*, by(month)
foreach var of varlist EIP* {
	replace `var' = `var'/1e9
}
tempfile EIP
save `EIP'


import fred PCE PCEPI PCEND, daterange(2012-01-01 2022-08-01) aggregate(monthly,avg) clear
gen month = mofd(daten)
format month %tm
keep month PCE*
order month
merge 1:1 month using `EIP', keep(mas mat) nogen
replace PCE = PCE/12
replace PCEND = PCEND/12
replace PCEPI = PCEPI/100
foreach var of varlist EIP* {
	replace `var' = 0 if mi(`var')
}

tsset month, m

* generate counterfactual PCE for total expenditure
gen cnt_PCE_EIP1_cont = PCE - 1/2*$EIP1_cont *(L1.EIP1+EIP1) if inrange(month,722,725)
gen cnt_PCE_EIP1_long = PCE - 1/2*$EIP1_cont *(L1.EIP1+EIP1) - max(1/3*$EIP1_long * (L2.EIP1+L3.EIP1+L4.EIP1),0) if inrange(month,722,727)

gen cnt_PCE_EIP2_cont = PCE - 1/2*$EIP2_cont *(L1.EIP2+EIP2) if inrange(month,731,734)
gen cnt_PCE_EIP2_long = PCE - 1/2*$EIP2_cont *(L1.EIP2+EIP2) - max(1/3*$EIP2_long * (L2.EIP2+L3.EIP2+L4.EIP2),0) if inrange(month,731,736)

gen cnt_PCE_EIP3_cont = PCE - 1/2*$EIP3_cont *(L1.EIP3+EIP3) if inrange(month,733,737)
gen cnt_PCE_EIP3_long = PCE - 1/2*$EIP3_cont *(L1.EIP3+EIP3) - max(1/3*$EIP3_long * (L2.EIP3+L3.EIP3+L4.EIP3),0) if inrange(month,733,738)

* generate counterfactual PCE for nondurables
gen cnt_PCE_EIP1_cont_nd = PCEND - 1/2*$EIP1_cont_nd *(L1.EIP1+EIP1) if inrange(month,722,725)
gen cnt_PCE_EIP1_long_nd = PCEND - 1/2*$EIP1_cont_nd *(L1.EIP1+EIP1) - max(1/3*$EIP1_long_nd * (L2.EIP1+L3.EIP1+L4.EIP1),0) if inrange(month,722,727)

gen cnt_PCE_EIP2_cont_nd = PCEND - 1/2*$EIP2_cont_nd *(L1.EIP2+EIP2) if inrange(month,731,734)
gen cnt_PCE_EIP2_long_nd = PCEND - 1/2*$EIP2_cont_nd *(L1.EIP2+EIP2) - max(1/3*$EIP2_long_nd * (L2.EIP2+L3.EIP2+L4.EIP2),0) if inrange(month,731,736)

gen cnt_PCE_EIP3_cont_nd = PCEND - 1/2*$EIP3_cont_nd *(L1.EIP3+EIP3) if inrange(month,733,737)
gen cnt_PCE_EIP3_long_nd = PCEND - 1/2*$EIP3_cont_nd *(L1.EIP3+EIP3) - max(1/3*$EIP3_long_nd * (L2.EIP3+L3.EIP3+L4.EIP3),0) if inrange(month,733,738)


* nominal to real
foreach var of varlist PCE PCEND cnt_PCE* {
	gen r`var' = `var'/PCEPI
}

* get average monthly growth rate
gen rPCE_growth = rPCE/L1.rPCE if month<=719
egen mrPCE_growth = mean(rPCE_growth)
gen rPCE_trend = rPCE if month==714
replace rPCE_trend = L1.rPCE_trend*mrPCE_growth if month>714

gen rPCEND_growth = rPCEND/L1.rPCEND if month<=719
egen mrPCEND_growth = mean(rPCEND_growth)
gen rPCEND_trend = rPCEND if month==714
replace rPCEND_trend = L1.rPCEND_trend*mrPCEND_growth if month>714


# delimit ;
graph twoway (line rPCE  month if month>=714, lc(black) lw(medthick))
	(line rcnt_PCE_EIP1_long month if month>=714, lc(dkgreen) lp(longdash))
	(line rcnt_PCE_EIP2_long month if month>=714, lc(dkorange) lp(longdash))
	(line rcnt_PCE_EIP3_long month if month>=714, lc(purple) lp(longdash))
	(line rPCE_trend month if month>=714, lc(black*0.4) lp(dash_dot)),
	ytitle("Billions of 2012 dollars") xtitle("")
	ylabel(900(50)1200) xlabel(714(6)749, format("%tmMon_YY"))
	ttext(950 2020m6 "Without EIP1", place(3))
	ttext(1050 2020m12 "Without EIP2", place(3))
	ttext(1130 2021m6 "Without EIP3", place(3))
	legend(order(1 "Personal consumption expenditure" 5 "Trend, 2012-2019")	rows(2));
# delimit cr
graph export "$root/fig_pce.pdf", replace
graph export "$root/fig_pce.svg", replace
export delimited month rPCE rcnt_PCE_EIP1_long rcnt_PCE_EIP2_long rcnt_PCE_EIP3_long rPCE_trend using "$root/fig_pce.csv", replace

# delimit ;
graph twoway (line rPCEND  month if month>=714, lc(black) lw(medthick))
	(line rcnt_PCE_EIP1_long_nd month if month>=714, lc(dkgreen) lp(longdash))
	(line rcnt_PCE_EIP2_long_nd month if month>=714, lc(dkorange) lp(longdash))
	(line rcnt_PCE_EIP3_long_nd month if month>=714, lc(purple) lp(longdash))
	(line rPCEND_trend month if month>=714, lc(black*0.4) lp(dash_dot)),
	ytitle("Billions of 2012 dollars") xtitle("")
	xlabel(714(6)749, format("%tmMon_YY"))
	ttext(210 2020m6 "Without EIP1", place(3))
	ttext(223 2021m1 "Without EIP2", place(3))
	ttext(240 2021m5 "Without EIP3", place(3))
	legend(order(1 "Non-durable personal consumption expenditure" 5 "Trend, 2012-2019")	rows(2));
# delimit cr
graph export "$root/fig_pcend.pdf", replace
graph export "$root/fig_pcend.svg", replace
export delimited month rPCEND rcnt_PCE_EIP1_long_nd rcnt_PCE_EIP2_long_nd rcnt_PCE_EIP3_long_nd rPCEND_trend using "$root/fig_pcend.csv", replace

